module.exports = async function (RED) {
  "use strict";
  const { got } = await import("got");
  var getBody = require("raw-body");

  function createResponseWrapper(node, res) {
    var wrapper = {
      _res: res,
    };
    var toWrap = [
      "append",
      "attachment",
      "cookie",
      "clearCookie",
      "download",
      "end",
      "format",
      "get",
      "json",
      "jsonp",
      "links",
      "location",
      "redirect",
      "render",
      "send",
      "sendfile",
      "sendFile",
      "sendStatus",
      "set",
      "status",
      "type",
      "vary",
    ];
    toWrap.forEach(function (f) {
      wrapper[f] = function () {
        // node.warn(RED._("httpin.errors.deprecated-call", { method: "msg.res." + f }));
        var result = res[f].apply(res, arguments);
        if (result === res) {
          return wrapper;
        } else {
          return result;
        }
      };
    });
    return wrapper;
  }

  var cookieParser = function (req, res, next) {
    next();
  };

  var httpMiddleware = function (req, res, next) {
    next();
  };

  var corsHandler = function (req, res, next) {
    next();
  };

  var metricsHandler = function (req, res, next) {
    next();
  };

  var jsonParser = function (req, res, next) {
    next();
  };

  var urlencParser = function (req, res, next) {
    next();
  };

  var multipartParser = function (req, res, next) {
    next();
  };

  // sita funkcija yra butina
  function rawBodyParser(req, res, next) {
    getBody(
      req,
      {
        length: req.headers["content-length"],
        encoding: "utf8",
      },
      function (err, buf) {
        if (err) {
          return next(err);
        }
        try {
          req.body = buf;
        } catch (err) {
          req.body = "";
        }

        next();
      }
    );
  }

  function registerOnJung(xnode) {
    if (xnode.datapointID == "") {
      console.log("registerOnJung> no datapointID provided, cancelling registration...");
      return "";
    }
    if (xnode.subscriptionID !== "") {
      console.log("registerOnJung> datapoint already registered (" + xnode.subscriptionID + "), cancelling registration...");
      return "";
    }

    if (xnode.settings.callbackURL === "") {
      console.log("registerOnJung> no callbackURL provided in settings, cancelling registration...");
      return "";
    }

    if (xnode.url.includes("callback URL")) {
      console.log("registerOnJung> not correct callbackURL provided, cancelling registration...");
      return "";
    }

    console.log(
      "registerOnJung> Registering `" +
        xnode.name +
        "` (" +
        xnode.datapointID +
        ") for active feedback from JUNG on listener URL=" +
        xnode.url
    );

    const url = "https://jung-api.test.agentilo.com/api/v2/subscriptions";
    const method = "POST";
    var opts = {};
    opts.timeout = { request: 5000 };
    opts.throwHttpErrors = false;
    opts.decompress = false;
    opts.method = method;
    opts.retry = { limit: 0 };
    opts.responseType = "buffer";
    opts.ignoreInvalidCookies = true;
    let ctSet = "Content-Type";
    let clSet = "Content-Length";

    opts.headers = {};
    opts.body = `
    {
      "data": {
        "type": "subscription",
        "relationships": {
          "subscriptionDatapoints": {
            "data": [
              {
                "id": "${xnode.datapointID}",
                "type": "datapoint"
              }
            ]
          }
        },
        "attributes": {
          "url": "${xnode.url}"
        }
      }
    }`;
    opts.headers[ctSet] = "application/vnd.api+json";
    opts.headers.Authorization = `Bearer ${xnode.settings.authenticationToken || ""}`;

    got(url, opts)
      .then((res) => {
        var msg = {};
        msg.statusCode = res.statusCode;
        msg.headers = res.headers;
        msg.responseUrl = res.url;
        msg.payload = res.body;
        msg.retry = 0;

        // console.log("after return> msg.statusCode=" + msg.statusCode);
        // 204 - ok
        // 401 - unauthorized

        if (msg.statusCode == 201) {
          var rez = JSON.parse(msg.payload);

          // console.log("subscriptionID=" + JSON.stringify(rez.data.type));  // turi buti subscription
          if (rez.data.type !== "subscription") {
            console.log("registerOnJung> Returned data type is not subscription (-> " + rez.data.type + ")");
            return "";
          }
          console.log("registerOnJung> got.subscriptionID=" + rez.data.id + " for " + xnode.url);
          xnode.subscriptionID = rez.data.id;
          return rez.data.id; // bet sito jau niekam nebereikia
          /* {
            links: { self: 'https://jung-api.test.agentilo.com/api/v2/subscriptions' },
            data: {
              type: 'subscription',
              id: 'c448069d-ee44-4342-8166-f7ea4c56304b',
              attributes: { url: 'https://nodered.jung.lt/jung/incoming3' },
              relationships: { subscriptionDatapoints: [Object], subscriptions: [Object] },
              links: {
                self: 'https://jung-api.test.agentilo.com/api/v2/subscriptions/c448069d-ee44-4342-8166-f7ea4c56304b'
              }
            }
          }  */
        } else {
          // console.log("  error in details: " + JSON.stringify(msg));
          // console.log("  body in details: " + JSON.stringify(res.body));
          console.log("registerOnJung> Registration code != 201, possible reason: " + msg.payload);
        }
      })
      .catch((err) => {
        console.error(err);
        // msg.payload = err.toString() + " : " + url;
        // msg.statusCode = err.code || (err.response ? err.response.statusCode : undefined);
      });

    return "";
  }

  function unregisterFromJung(xnode) {
    console.log("unregisterFromJung> delete subscriptionID=" + xnode.subscriptionID);
    if (xnode.subscriptionID == "") return "";

    const url = "https://jung-api.test.agentilo.com/api/v2/subscriptions/" + xnode.subscriptionID;
    const method = "DELETE";
    var opts = {};
    opts.timeout = { request: 5000 };
    opts.throwHttpErrors = false;
    opts.decompress = false;
    opts.method = method;
    opts.retry = { limit: 0 };
    opts.responseType = "buffer";
    opts.ignoreInvalidCookies = true;
    let ctSet = "Content-Type";
    let clSet = "Content-Length";

    opts.headers = {};
    opts.body = "";
    opts.headers[ctSet] = "application/vnd.api+json";
    opts.headers.Authorization = `Bearer ${xnode.settings.authenticationToken || ""}`;

    got(url, opts)
      .then((res) => {
        // console.log("result: " + res.statusCode);
        if (res.statusCode == 204) {
          // console.log(xnode.url + " disconnected successfully");
          return;
        }
        // 200 kai yra klaida - nenurodytas ID
        else {
          // 200 klaida jau zinau
          console.log(xnode.url + " result=" + res.statusCode);
        }
      })
      .catch((err) => {
        console.error(err);
        // msg.payload = err.toString() + " : " + url;
        // msg.statusCode = err.code || (err.response ? err.response.statusCode : undefined);
      });

    return;
  }

  function HTTPIn(n) {
    RED.nodes.createNode(this, n);
    if (RED.settings.httpNodeRoot !== false) {
      if (!n.url) {
        this.warn("No URL defined, skipping further listener initialization");
        return;
      }
      this.url = n.url;
      /* if (this.url[0] !== "/") {
        this.url = "/" + this.url;
      }*/
      this.method = n.method;

      var node = this;
      node.settings = RED.nodes.getNode(n.settings);
      const datapointID = n.datapointID || "";
      node.datapointID = datapointID;
      node.subscriptionID = "";

      /* registerOnJung(node).then((rez) => {
        console.log("registerOnJung> rez=" + rez);
        this.subscriptionID = rez;
      }); */
      registerOnJung(node);
      // console.log("** registered " + this.url + ", on " + this.subscriptionID);

      this.errorHandler = function (err, req, res, next) {
        // node.warn(err);
        console.log(err);
        res.sendStatus(500);
      };

      this.callback = function (req, res) {
        // console.log("jung-receive-status> in callback");
        // console.log(typeof req); // object
        // console.log(typeof req.body); // string
        // console.log(JSON.parse(req.body));   // object

        var obody = [];
        var sbody = "";
        if (typeof req.body === "string") {
          sbody = req.body;
          obody = JSON.parse(req.body);
        } else {
          sbody = JSON.stringify(req.body);
          obody = req.body;
        }

        var msgid = RED.util.generateId();
        res._msgid = msgid;
        // Since Node 15, req.headers are lazily computed and the property
        // marked as non-enumerable.
        // That means it doesn't show up in the Debug sidebar.
        // This redefines the property causing it to be evaluated *and*
        // marked as enumerable again.
        Object.defineProperty(req, "headers", {
          value: req.headers,
          enumerable: true,
        });

        if (node.method == "post") {
          // debug
          if (false) {
            console.log("receive.js> in post. smsg received: " + sbody + ", type: " + typeof sbody);
            console.log("receive.js> in post. omsg received: " + obody + ", type: " + typeof obody);
            console.log('receive.js> in post. sbody.includes("agentilo.com/api/"): ' + sbody.includes("agentilo.com/api/"));
            console.log(
              'receive.js> in post. sbody.includes(\'"type":"datapoint"\'): ' +
                sbody.replace(" ", "").includes('"type":"datapoint"')
            );
          }
          if (sbody.includes("agentilo.com/api/") && sbody.replace(" ", "").includes('"type":"datapoint"')) {
            // console.log("receive.js> agentilo filter ok, datapoint filter ok");
            // console.log("receive.js> ieskau datapointID=" + datapointID);
            if (datapointID !== "") {
              if (sbody.includes('"id":"' + datapointID + '"')) {
                // console.log("receive.js> req.body=" + req.body);
                // console.log("receive.js> req.body.data=" + req.body.data); // undefined
                // console.log("receive.js> obody=" + JSON.stringify(obody));
                const rez = obody.data[0].attributes.value;
                // console.log("receive.js> radau, rez=" + JSON.stringify(rez));
                node.send({ _msgid: msgid, req: req, res: createResponseWrapper(node, res), payload: rez });
                res.sendStatus(204);
                return;
              }
            }
          }
          res.sendStatus(400);
        } else {
          console.log("jung-receive-status> received " + node.method + " request, not supported");
          res.sendStatus(405);
        }
      };

      // metodas turi būti tik post - čia aš registruoju savo URL ir callback'ą NodeRed sistemoje
      RED.httpNode.post(
        this.url,
        cookieParser,
        httpMiddleware,
        corsHandler,
        metricsHandler,
        jsonParser,
        urlencParser,
        multipartParser,
        rawBodyParser,
        this.callback,
        this.errorHandler
      );

      this.on("close", function (done) {
        var node = this;
        if (node.subscriptionID !== "") {
          // console.log("closing `" + this.name + "` with subscriptionID: " + node.subscriptionID);
          unregisterFromJung(node);
        }
        console.log("waiting 1 seconds until everything closes...");
        setTimeout(() => {
          /* Code to run after 1 seconds */
          // console.log("*** really finished ***");
          done();
        }, 1000);
        RED.httpNode._router.stack.forEach(function (route, i, routes) {
          if (route.route && route.route.path === node.url && route.route.methods[node.method]) {
            routes.splice(i, 1);
          }
        });
      });
    } else {
      this.warn(RED._("httpin.errors.not-created"));
    }
  }
  RED.nodes.registerType("jung-receive-status", HTTPIn);
};
